IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_CONCILIADOR_BAIXA_AGENDAMENTO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_CONCILIADOR_BAIXA_AGENDAMENTO]
GO

CREATE PROCEDURE [dbo].[P_CONCILIADOR_BAIXA_AGENDAMENTO] AS

SET NOCOUNT ON;
BEGIN TRY
BEGIN
	DECLARE @GRP_ECON INT = 0
	DECLARE @FILIAL INT = 0
	DECLARE @DT_MOV DATE = '1900-01-01'
	DECLARE @CD_LOTE BIGINT
	DECLARE @CD_PARCELA_LOTE INT
	DECLARE @CD_CTR_MOV_LOTE BIGINT
	DECLARE @CD_FILIAL_AGEND INT
	DECLARE @CD_EMP_AGEND INT
	DECLARE @DT_PGTO_AGEND DATETIME

	--ST_STATUS = 0: PENDENTE
	--ST_STATUS = 1: FINALIZADO
	--ST_STATUS = 2: ERRO

	DECLARE LotesBaixa CURSOR FAST_FORWARD FOR
	SELECT PAGAMENTO.IDT_LOTE, PAGAMENTO.PARCELA_LOTE, AGENDAMENTO.CD_FILIAL, AGENDAMENTO.CD_EMP, AGENDAMENTO.DT_PGTO
	  FROM CONCILIACAO_CARTOES_LINX_CONCILIADOR_PGTO AS PAGAMENTO
	 INNER JOIN CONCILIACAO_CARTOES_LINX_CONCILIADOR_LOTE AS LOTE ON LOTE.IDT_LOTE = PAGAMENTO.IDT_LOTE
	 INNER JOIN CONCILIACAO_CARTOES_LINX_CONCILIADOR_PGTO_AGENDAMENTO AS AGENDAMENTO ON
	       AGENDAMENTO.CD_EMP = LOTE.CD_EMP
	   AND AGENDAMENTO.CD_FILIAL = PAGAMENTO.CD_FILIAL
	   AND AGENDAMENTO.DT_PGTO = PAGAMENTO.DT_PAGAMENTO
	   AND AGENDAMENTO.ST_STATUS = 0

	 WHERE LOTE.CD_GRUPO NOT IN (141, 142, 143)
	   AND NOT EXISTS (SELECT IDT_LOTE
			             FROM CONCILIACAO_CARTOES_LINX_CONCILIADOR_PAGO
			            WHERE CONCILIACAO_CARTOES_LINX_CONCILIADOR_PAGO.IDT_LOTE = LOTE.IDT_LOTE
				          AND CONCILIACAO_CARTOES_LINX_CONCILIADOR_PAGO.PARCELA_LOTE = PAGAMENTO.PARCELA_LOTE)
	 ORDER BY PAGAMENTO.CD_FILIAL, PAGAMENTO.DT_PAGAMENTO
	OPEN LotesBaixa
	FETCH NEXT FROM LotesBaixa INTO @CD_LOTE, @CD_PARCELA_LOTE, @CD_FILIAL_AGEND, @CD_EMP_AGEND, @DT_PGTO_AGEND

	WHILE @@FETCH_STATUS = 0 
	BEGIN
		BEGIN TRY
				DECLARE @CD_EMP AS INT
				DECLARE @CD_FILIAL AS INT
				DECLARE @CD_GRP_ECON AS INT
				DECLARE @CD_CLI AS INT
				DECLARE @RZ_CLI AS VARCHAR(255)
				DECLARE @CD_CONTA AS INT
				DECLARE @VLR_LANC AS NUMERIC(18,2)
				DECLARE @VLR_ALUGUEL AS NUMERIC(18,2)
				DECLARE @CD_MODALIDADE AS INT
				DECLARE @DT_VENCTO AS DATE
				DECLARE @DT_LANC AS DATE
				DECLARE @DS_HIST AS VARCHAR(100)
				DECLARE @CD_CTR_MOV AS BIGINT
				DECLARE @CD_CTR_MOV_BAIXA AS BIGINT
				DECLARE @CD_BC_LANC AS BIGINT
				DECLARE @CD_DOC AS INT
				DECLARE @CD_CLAS_FLUXO_CAIXA AS INT
				DECLARE @CD_CNT AS INT
				DECLARE @CD_CNT_CTB AS INT
				DECLARE @CD_CENTRO_CUSTO AS INT
				DECLARE @CD_CENTRO_CUSTO_FILIAL AS INT
				DECLARE @CD_CENTRO_CTB AS INT
				DECLARE @CD_RAT_DESP AS BIGINT

				SELECT DISTINCT @CD_EMP = PAGAMENTO.CD_EMP
				, @CD_GRP_ECON = GRP_ECON.CD_GRP_ECON
				, @CD_FILIAL = PAGAMENTO.CD_FILIAL
				, @CD_CLI = ISNULL(rc.CD_CLI, 0)
				, @RZ_CLI = CLI.RZ_CLI
				, @VLR_LANC = PAGAMENTO.VLR_LIQUIDO
				, @VLR_ALUGUEL = PAGAMENTO.VLR_BRUTO - PAGAMENTO.VLR_LIQUIDO
				, @CD_MODALIDADE = isnull(rc.TP_ADM, 0)
				, @DT_VENCTO = PAGAMENTO.DT_PAGAMENTO
				, @DT_LANC = LOTE.DT_LOTE
				, @DS_HIST = 'RECEBIMENTO DE VENDA DE CARTES' + CONVERT(VARCHAR, PAGAMENTO.DT_PAGAMENTO, 103) +  ' FILIAL: ' + CONVERT(VARCHAR, PAGAMENTO.CD_FILIAL)
				FROM CONCILIACAO_CARTOES_LINX_CONCILIADOR_LOTE LOTE
				INNER JOIN CONCILIACAO_CARTOES_LINX_CONCILIADOR_PGTO PAGAMENTO ON LOTE.IDT_LOTE = PAGAMENTO.IDT_LOTE
				INNER JOIN PRC_GRP_ECON_PRC_FILIAL GRP_ECON ON GRP_ECON.CD_EMP = PAGAMENTO.CD_EMP AND GRP_ECON.CD_FILIAL = PAGAMENTO.CD_FILIAL
				INNER JOIN V_CONCILIACAO_CARTOES_LINX_CONCILIADOR_STATUS_CONCILIACAO sts ON LOTE.IDT_LOTE = sts.IDT_LOTE_REDE
				LEFT JOIN V_CONCILIACAO_CARTOES_LINX_CONCILIADOR_RC_ADM_CARTAO AS Rc ON LOTE.IDT_LOTE = rc.IDT_LOTE_REDE
					AND LOTE.CD_FILIAL = rc.CD_FILIAL
				LEFT JOIN RC_CLI AS CLI ON RC.CD_CLI = CLI.CD_CLI
	
				WHERE PAGAMENTO.IDT_LOTE = @CD_LOTE
				AND PAGAMENTO.PARCELA_LOTE = @CD_PARCELA_LOTE

				SET @CD_CONTA = ISNULL((SELECT TOP 1 CD_CNT FROM CONCILIACAO_CARTOES_LINX_CONCILIADOR_BC_CONTAS WHERE CD_FILIAL = @CD_FILIAL), 0)
				IF @CD_CONTA = 0
					RAISERROR('Cdigo da conta no encontrado', 16, 1);

				--Lote de baixas realizadas
				IF (@GRP_ECON <> @CD_GRP_ECON) OR (@FILIAL <> @CD_FILIAL) OR (@DT_MOV <> @DT_LANC)
				BEGIN
					SET @CD_CTR_MOV_LOTE = (SELECT ISNULL(MAX(ISNULL(CD_CTR_LOTE, 0)), 0) + 1 FROM RC_ADM_CARTAO_MOV_LOTE)

					INSERT RC_ADM_CARTAO_MOV_LOTE (CD_CTR_LOTE, CD_GRP_ECON, DT_MOV, CD_FILIAL)
					VALUES (@CD_CTR_MOV_LOTE, @CD_GRP_ECON, @DT_LANC, @CD_FILIAL)

					SET @GRP_ECON = @CD_GRP_ECON
					SET @FILIAL = @CD_FILIAL
					SET @DT_MOV = @DT_LANC
				END

				SET @CD_CTR_MOV = (SELECT ISNULL(MAX(ISNULL(CD_CTR, 0)), 0) + 1 FROM RC_ADM_CARTAO_MOV)

				--Dados da Baixa
				INSERT RC_ADM_CARTAO_MOV (CD_CTR, CD_EMP, CD_CLI, TP_LANC, DT_LANC, DT_VENCTO, VLR_LANC, VLR_TAXA, CD_USU, DT_CAD, HIST_LANC, CD_GRP_ECON, CD_FILIAL, MODALIDADE)
				VALUES (@CD_CTR_MOV, @CD_EMP, @CD_CLI, 1, @DT_LANC, @DT_VENCTO, @VLR_LANC, @VLR_ALUGUEL, 1, GetDate(), @DS_HIST, @CD_GRP_ECON, @CD_FILIAL, @CD_MODALIDADE)

				--Relacionamento do lancamento do cartao com o controle de lote
				INSERT RC_ADM_CARTAO_MOV_LOTE_RC_ADM_CARTAO_MOV (CD_CTR_LOTE, CD_CTR)
				VALUES (@CD_CTR_MOV_LOTE, @CD_CTR_MOV)

				--Relacionamento conciliador com a movimentao
				INSERT CONCILIACAO_CARTOES_LINX_CONCILIADOR_PGTO_RC_ADM_CARTAO_MOV (IDT_LOTE, PARCELA_LOTE, CD_CTR_LOTE, CD_CTR)
				VALUES (@CD_LOTE, @CD_PARCELA_LOTE, @CD_CTR_MOV_LOTE, @CD_CTR_MOV)

				--Relao de lotes baixados e parcelas pagas
				INSERT CONCILIACAO_CARTOES_LINX_CONCILIADOR_PAGO (CD_EMP, CD_FILIAL, IDT_LOTE, PARCELA_LOTE, CD_CTR_ADM_CARTAO_MOV, CD_USU)
				VALUES (@CD_EMP, @CD_FILIAL, @CD_LOTE, @CD_PARCELA_LOTE, @CD_CTR_MOV, 1)

				--PRINT '@CD_CTR_MOV (baixa): ' + CONVERT(VARCHAR, @CD_CTR_MOV)

				--Validaes
				SET @CD_DOC = ISNULL((SELECT TOP 1 CD_DOC FROM GLB_DOC WHERE TP_DOC = 1), 0)
				IF @CD_DOC = 0
					RAISERROR('CD_DOC no encontrado', 16, 1);
	
				SET @CD_CLAS_FLUXO_CAIXA = (SELECT CONVERT(INT, VALOR) FROM PRC_EMP_CONFIG WHERE CD_CHAVE = 'CD_CLAS_FLUXO_CX_BAIXA_RECBTO_ADM_CARTOES')

				/*
				--Testa se a data de vencto esta bloqueada
				If Exists(SELECT TOP 1 DT_LANCTO FROM BC_LANC_DT_CONC_BLQ WHERE DT_LANCTO >= @DT_LANC)
					--ERRO

				--Testando se h conta caixa padrao
				SET @CD_CNT = ISNULL((SELECT INSULL(BC_CONTAS.CD_CNT,0) 
							   FROM PRC_GRP_ECON_PRC_FILIAL, BC_CONTAS, BC_CONTAS_PRC_GRP_ECON
							   WHERE BC_CONTAS.CD_EMP = BC_CONTAS_PRC_GRP_ECON.CD_EMP AND
							   BC_CONTAS.CD_CNT = BC_CONTAS_PRC_GRP_ECON.CD_CNT AND
							   PRC_GRP_ECON_PRC_FILIAL.CD_EMP = BC_CONTAS_PRC_GRP_ECON.CD_EMP AND
							   PRC_GRP_ECON_PRC_FILIAL.CD_GRP_ECON = BC_CONTAS_PRC_GRP_ECON.CD_GRP_ECON AND
							   BC_CONTAS.CD_EMP = @CD_EMP
							   AND BC_CONTAS.TP_CNT = 0), 0)

				If @CD_CNT = 0
					--ERRO
				*/
				--Fim validaes

				--Gravao no bancrio
				SET @CD_BC_LANC = (SELECT ISNULL(MAX(ISNULL(CD_BC_LANC, 0)), 0) + 1 FROM BC_LANC)

				INSERT BC_LANC (CD_EMP, CD_BC_LANC, VLR_LANC, CD_CNT, HIST_LANC, CD_DOC, TP_LANC, DT_LANCTO, CD_USU, DT_CAD, HIST_LANC_CPL, SLD_INI, CD_TP_LANC, ORIG_LANC, DT_COMP)
				VALUES (@CD_EMP, @CD_BC_LANC, @VLR_LANC, @CD_CONTA, 'RECEBIMENTO OPERADORA DE CARTO: ' + @RZ_CLI + ' - ' + Convert(Varchar, @CD_MODALIDADE), @CD_DOC, 0, @DT_VENCTO, 1, GETDATE(), '', 0, @CD_CLAS_FLUXO_CAIXA, 0, @DT_VENCTO)

				--Relao do bancrio com o lote baixado
				INSERT BC_LANC_RC_ADM_CARTAO_MOV (CD_EMP, CD_BC_LANC, CD_CTR)
				VALUES (@CD_EMP, @CD_BC_LANC, @CD_CTR_MOV)
	
				--PRINT '@CD_BC_LANC : ' + CONVERT(VARCHAR, @CD_BC_LANC)

				SET @CD_CTR_MOV_BAIXA = (SELECT ISNULL(MAX(ISNULL(CD_CTR_LOTE, 0)), 0) + 1 FROM RC_ADM_CARTAO_MOV_BAIXA)

				--Relao do lote
				INSERT RC_ADM_CARTAO_MOV_BAIXA (CD_CTR_LOTE, CD_CTR, DT_CAD)
				VALUES (@CD_CTR_MOV_BAIXA, @CD_CTR_MOV, GETDATE())

				--Gravaes de valor de aluguel
				SET @CD_CTR_MOV = (SELECT ISNULL(MAX(ISNULL(CD_CTR, 0)), 0) + 1 FROM RC_ADM_CARTAO_MOV)
				SET @DS_HIST = 'VALOR DE ALUGUEL DE POS FILIAL: ' + CONVERT(VARCHAR, @CD_FILIAL)

				INSERT RC_ADM_CARTAO_MOV (CD_CTR, CD_EMP, CD_CLI, TP_LANC, DT_LANC, DT_VENCTO, VLR_LANC, VLR_TAXA, CD_USU, DT_CAD, HIST_LANC, CD_GRP_ECON, EXPT_CTB, CD_FILIAL, MODALIDADE)
				VALUES (@CD_CTR_MOV, @CD_EMP, @CD_CLI, 0, @DT_VENCTO, @DT_VENCTO, @VLR_ALUGUEL, 0, 1, GetDate(), @DS_HIST, @CD_GRP_ECON, 0, @CD_FILIAL, @CD_MODALIDADE)

				--Rateio da despesa
				SELECT @CD_CNT_CTB = RC_ADM_CARTAO_MOV_GLB_DESP_REC.CD_DESP_REC
					 , @CD_CENTRO_CUSTO_FILIAL = ISNULL(RC_ADM_CARTAO_MOV_GLB_DESP_REC.FLAG_CENTRO_CUSTO_FILIAL,0)
					 , @CD_CENTRO_CUSTO = ISNULL(RC_ADM_CARTAO_MOV_GLB_DESP_REC_CTB_CENTRO_CUSTO.CD_CENTRO_CTB, 0)
				FROM RC_ADM_CARTAO_MOV_GLB_DESP_REC

				LEFT OUTER JOIN RC_ADM_CARTAO_MOV_GLB_DESP_REC_CTB_CENTRO_CUSTO ON
								RC_ADM_CARTAO_MOV_GLB_DESP_REC.CD_EMP = RC_ADM_CARTAO_MOV_GLB_DESP_REC_CTB_CENTRO_CUSTO.CD_EMP
							AND RC_ADM_CARTAO_MOV_GLB_DESP_REC.CD_DESP_REC = RC_ADM_CARTAO_MOV_GLB_DESP_REC_CTB_CENTRO_CUSTO.CD_DESP_REC
							AND RC_ADM_CARTAO_MOV_GLB_DESP_REC.TP_DESP = RC_ADM_CARTAO_MOV_GLB_DESP_REC_CTB_CENTRO_CUSTO.TP_DESP
							AND RC_ADM_CARTAO_MOV_GLB_DESP_REC.CD_CLI = RC_ADM_CARTAO_MOV_GLB_DESP_REC_CTB_CENTRO_CUSTO.CD_CLI

				WHERE RC_ADM_CARTAO_MOV_GLB_DESP_REC.CD_EMP = @CD_EMP
				  AND RC_ADM_CARTAO_MOV_GLB_DESP_REC.CD_CLI = @CD_CLI
				  AND RC_ADM_CARTAO_MOV_GLB_DESP_REC.TP_DESP = 0 --LancAluguelPOS

				IF @CD_CENTRO_CUSTO_FILIAL <> 0
				BEGIN
					SET @CD_CENTRO_CUSTO = (SELECT CONVERT(INT, VALOR) FROM PRC_FILIAL_CONFIG WHERE CD_FILIAL = @CD_FILIAL AND CD_CHAVE = 'COD_CENTRO_CUSTO_FILIAL')
					IF @CD_CENTRO_CUSTO = 0
						RAISERROR('CD_CENTRO_CUSTO no encontrado', 16, 1);
				END

				SET @CD_RAT_DESP = (SELECT ISNULL(MAX(ISNULL(CD_RAT_DESP, 0)), 0) + 1 FROM PG_DESP_RAT WHERE CD_EMP = @CD_EMP)

				--Gravando despesa
				INSERT PG_DESP_RAT (CD_EMP, CD_FILIAL, CD_RAT_DESP, CD_DESP_REC, PERC_DESP, VLR_DESP, MES_ANO_REF)
				VALUES (@CD_EMP, @CD_FILIAL, @CD_RAT_DESP, @CD_CNT_CTB, 100, @VLR_ALUGUEL, LEFT(@DT_VENCTO, 8) + '01')

				SET @CD_CENTRO_CTB = ISNULL((SELECT ISNULL(CD_CENTRO_CTB, 0) FROM PG_DESP_RAT_CTB_CENTRO_CUSTO WHERE CD_EMP = @CD_EMP AND CD_CENTRO_CTB = @CD_CENTRO_CUSTO AND CD_RAT_DESP = @CD_RAT_DESP), 0)

				IF @CD_CENTRO_CTB > 0
				BEGIN
					UPDATE PG_DESP_RAT_CTB_CENTRO_CUSTO
					SET CD_EMP = @CD_EMP
					, CD_CENTRO_CTB = @CD_CENTRO_CUSTO
					, CD_RAT_DESP = @CD_RAT_DESP
					, VLR_RAT_DESP = @VLR_ALUGUEL
					, DT_CAD = GETDATE()
					, CD_USU = 1
					WHERE CD_EMP = @CD_EMP
					AND CD_CENTRO_CTB = @CD_CENTRO_CUSTO
					AND CD_RAT_DESP = 0
				END
				ELSE
				BEGIN
					INSERT PG_DESP_RAT_CTB_CENTRO_CUSTO (CD_EMP, CD_CENTRO_CTB, CD_RAT_DESP, VLR_RAT_DESP, DT_CAD, CD_USU)
					VALUES (@CD_EMP, @CD_CENTRO_CUSTO, @CD_RAT_DESP, @VLR_ALUGUEL, GETDATE(), 1)
				END

				--Movimento de administradora de cartao
				INSERT PG_DESP_RAT_RC_ADM_CARTAO_MOV (CD_EMP, CD_RAT_DESP, CD_CTR)
				VALUES (@CD_EMP, @CD_RAT_DESP, @CD_CTR_MOV)

				--PRINT '@CD_RAT_DESP: ' + CONVERT(VARCHAR, @CD_RAT_DESP)

				INSERT RC_ADM_CARTAO_MOV_BAIXA (CD_CTR_LOTE, CD_CTR, DT_CAD)
				VALUES (@CD_CTR_MOV_BAIXA, @CD_CTR_MOV, GETDATE())

				--PRINT '@CD_CTR_MOV (Aluguel): ' + CONVERT(VARCHAR, @CD_CTR_MOV)
		END TRY
		BEGIN CATCH
			DECLARE @ErrorMessage VARCHAR(4000) = ERROR_MESSAGE();
		    DECLARE @ErrorSeverity INT = ERROR_SEVERITY();
		    DECLARE @ErrorState INT = ERROR_STATE();

			INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
				SELECT
					ERROR_NUMBER() AS numero,
					ERROR_SEVERITY() AS severidade,
					ERROR_STATE() AS estado,
					ERROR_PROCEDURE() AS rotina,
					ERROR_LINE() AS linha,
					ERROR_MESSAGE() AS mensagem,
					GETDATE() AS dtErro;
			
			UPDATE CONCILIACAO_CARTOES_LINX_CONCILIADOR_PGTO_AGENDAMENTO
			SET ST_STATUS = 2 --ERRO
			WHERE CD_FILIAL = @CD_FILIAL_AGEND
			AND CD_EMP = @CD_EMP_AGEND
			AND CAST(DT_PGTO AS DATE) = CAST(@DT_PGTO_AGEND AS DATE);

			INSERT INTO CONCILIACAO_CARTOES_LINX_CONCILIADOR_PGTO_LOG_ERROR
			VALUES (@ErrorMessage, @CD_FILIAL_AGEND, @CD_EMP_AGEND, CAST(@DT_PGTO_AGEND AS DATE));

			RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);

		END CATCH

		FETCH NEXT FROM LotesBaixa INTO @CD_LOTE, @CD_PARCELA_LOTE, @CD_FILIAL_AGEND, @CD_EMP_AGEND, @DT_PGTO_AGEND
		END

		

	CLOSE LotesBaixa;
	DEALLOCATE LotesBaixa;

	--Fim processamento Cursor / Status FINALIZADO para agendamentos completos.

	UPDATE AGENDAMENTO
	SET ST_STATUS = 1
	  FROM CONCILIACAO_CARTOES_LINX_CONCILIADOR_PGTO_AGENDAMENTO AS AGENDAMENTO
	  WHERE AGENDAMENTO.ST_STATUS = 0
	   AND NOT EXISTS (SELECT 1 
					   FROM CONCILIACAO_CARTOES_LINX_CONCILIADOR_PGTO_LOG_ERROR AS LOGGER
					   WHERE LOGGER.CD_FILIAL = AGENDAMENTO.CD_FILIAL
							 AND LOGGER.CD_EMP = AGENDAMENTO.CD_EMP
							 AND LOGGER.DT_PGTO = AGENDAMENTO.DT_PGTO)
END
END TRY
BEGIN CATCH
	CLOSE LotesBaixa
	DEALLOCATE LotesBaixa
	
	 DECLARE @ErrorMessageFinal VARCHAR(4000) = ERROR_MESSAGE();
	   DECLARE @ErrorSeverityFinal INT = ERROR_SEVERITY();
	   DECLARE @ErrorStateFinal INT = ERROR_STATE();

	INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
		SELECT
			ERROR_NUMBER() AS numero,
			ERROR_SEVERITY() AS severidade,
			ERROR_STATE() AS estado,
			ERROR_PROCEDURE() AS rotina,
			ERROR_LINE() AS linha,
			ERROR_MESSAGE() AS mensagem,
			GETDATE() AS dtErro;
			

	RAISERROR(@ErrorMessageFinal, @ErrorSeverityFinal, @ErrorStateFinal);

END CATCH		
